
//////////////////////////
//Created by LostSinner//
////////////////////////
using System;
using Server.Items;

namespace Server.Items
{
	public class VampGorget : LeatherGorget
	{
		public override int BasePhysicalResistance{ get{ return 8; } }
		public override int BaseFireResistance{ get{ return 10; } }
		public override int BaseColdResistance{ get{ return 8; } }
		public override int BasePoisonResistance{ get{ return 8; } }
		public override int BaseEnergyResistance{ get{ return 8; } }

		public override int ArtifactRarity{ get{ return 6; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		public override int AosStrReq{ get{ return 90; } }
		public override int OldStrReq{ get{ return 90; } }

		public override int OldDexBonus{ get{ return -1; } }

		public override int ArmorBase{ get{ return 40; } }

		public override ArmorMaterialType MaterialType{ get{ return ArmorMaterialType.Leather; } }

		public override ArmorMeditationAllowance DefMedAllowance{ get{ return ArmorMeditationAllowance.All; } }

		[Constructable]
		public VampGorget()
		{
			ItemID = 5063;
			Weight = 2.0;
			Name = "Lamia Iugulo";
			Hue = 37;
         LootType = LootType.Cursed;
			Attributes.ReflectPhysical = 5;
			Attributes.CastSpeed = 1;
			Attributes.CastRecovery = 2;
			Attributes.SpellDamage = 5;
			Attributes.RegenMana = 2;
			Attributes.LowerManaCost = 4;
		}

		public VampGorget( Serial serial ) : base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}	
		public override void OnDoubleClick( Mobile from )
		{	
			if ( !IsChildOf( from.Backpack ) )
			   from.SendLocalizedMessage( 1060640 );
			else if( !from.HasTrade )
			{
			
				if( this.ItemID == 5063 ) this.ItemID = 5139;
				else if( this.ItemID == 5139 ) this.ItemID = 10105;
				else if( this.ItemID == 10105 ) this.ItemID = 10106;
				else if( this.ItemID == 10106 ) this.ItemID = 7944;
				else if( this.ItemID == 7944 ) this.ItemID = 4229;
				else if( this.ItemID == 4229 ) this.ItemID = 5063;
			}
		}	
	}
}